#include <bits/stdc++.h>

using namespace std;

struct NODE
{
    int cnt;
    char l, r;
    NODE(){}
    NODE(int cnt_, char l_, char r_)
    {
        cnt = cnt_; l = l_; r = r_;
    }
};

NODE mrg ( NODE a, NODE b )
{
    NODE res;

    res.cnt = a.cnt + b.cnt;
    res.l = a.l;
    res.r = b.r;

    if ( a.r <= b.l )
        res.cnt--;

    return res;
}

vector<NODE> tree;
string s;
int n, q;

void build ( int v, int tl, int tr )
{
    if ( tl == tr )
    {
        tree[v] = NODE( 1, s[tl], s[tr] );
        return;
    }

    int mid = ( tl + tr ) / 2;

    build( 2*v, tl, mid );
    build( 2*v+1, mid+1, tr );

    tree[v] = mrg( tree[2*v], tree[2*v+1] );
}

NODE tget ( int v, int tl, int tr, int l, int r )
{
    if ( l <= tl && tr <= r )
        return tree[v];

    int mid = ( tl + tr ) / 2;

    if ( mid < l )
        return tget( 2*v+1, mid+1, tr, l, r );

    if ( r <= mid )
        return tget( 2*v, tl, mid, l, r );

    return mrg( tget( 2*v, tl, mid, l, r ), tget( 2*v+1, mid+1, tr, l, r ) );
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    cin >> s >> q;
    n = s.size();

    tree.assign( 4*n+100, NODE() );
    build( 1, 0, n-1 );

    while ( q-- )
    {
        int l, r;
        cin >> l >> r;
        l--, r--;

        NODE res = tget( 1, 0, n-1, l, r );

        cout << res.cnt << '\n';
    }

    return 0;
}
